function initfreq = readsteadystates(nuts_soil)
    %These are the steady states  for each subregion (NUTS1_soiltype) caluclated 
    %according to Sharp et al 2020
    %These are used to provide the initial frequency of each crop
    if nuts_soil=="C_H"
        initfreq=[0
    0.007127555
    0.068108769
    0.249732153
    0.011865461
    0.188233045
    0.078806817
    0.013199312
    0.061623377
    0.023003601
    0.029454717
    0.268845193
    ];
    elseif nuts_soil=="C_M"
        initfreq=[0
    0.025441395
    0.05951207
    0.103162817
    0.011521979
    0.124173319
    0.055063541
    0.007031307
    0.07932706
    0.026609767
    0.155908142
    0.352248601
    ];
    elseif nuts_soil=="C_L"
        initfreq=[0
    0.021495031
    0.064112783
    0.092620282
    0.015504643
    0.127562173
    0.051794274
    0.009691423
    0.083976936
    0.030993358
    0.161394432
    0.340854665
    ];
    elseif nuts_soil=="D_H"
        initfreq=[0
    0
    0
    1
    0
    0
    0
    0
    0
    0
    0
    0
    ];
    elseif nuts_soil=="D_M"
        initfreq=[0
    0.008340814
    0.096373273
    0.334256667
    0.100803169
    0.021026368
    0.091101664
    0.020346525
    0.099835951
    0.060332859
    0.066344242
    0.101238469
    ];
    elseif nuts_soil=="D_L"
        initfreq=[0
    0.009883542
    0.09172574
    0.162581654
    0.158043118
    0.027715051
    0.134514024
    0.045980945
    0.080276454
    0.074287932
    0.08532395
    0.12966759
    ];
    elseif nuts_soil=="E_H"
        initfreq=[0.019968707
    0.026876753
    0.059164337
    0.119203025
    0.026052596
    0.096715045
    0.10580519
    0.027746492
    0.066328132
    0.073277506
    0.09663379
    0.282228428
    ];
    elseif nuts_soil=="E_M"
        initfreq=[0.012715483
    0.02743257
    0.052741148
    0.144756404
    0.023574382
    0.104869048
    0.075806973
    0.024888535
    0.065612776
    0.057302902
    0.110139186
    0.300160593
    ];
    elseif nuts_soil=="E_L"
        initfreq=[0.022988824
    0.022978832
    0.060675121
    0.126534622
    0.034155906
    0.100117716
    0.077951846
    0.030049856
    0.060018333
    0.059391507
    0.129150456
    0.275986982
    ];
    elseif nuts_soil=="F_H"
        initfreq=[0.019077998
    0.043224297
    0.047503996
    0.091976879
    0.033900148
    0.169667822
    0.077782949
    0.010910501
    0.05288936
    0.067708611
    0.081041962
    0.304315479
    ];
    elseif nuts_soil=="F_M"
        initfreq=[0.030748068
    0.042823467
    0.046121644
    0.077656147
    0.0416639
    0.149623786
    0.089418134
    0.017989934
    0.063226916
    0.058604948
    0.088561735
    0.293561321
    ];
    elseif nuts_soil=="F_L"
        initfreq=[0.063626582
    0.030536199
    0.058116571
    0.086581074
    0.057352518
    0.098467671
    0.128809788
    0.047716087
    0.065322593
    0.054812172
    0.074577496
    0.23408125
    ];
    elseif nuts_soil=="G_H"
        initfreq=[0
    0.052838339
    0.06883777
    0.081519711
    0.048817913
    0.133624011
    0.088228649
    0.00646936
    0.034783007
    0.069228523
    0.11010174
    0.305550978
    ];
    elseif nuts_soil=="G_M"
        initfreq=[0
    0.023432917
    0.066311446
    0.115179131
    0.07361522
    0.119452196
    0.089894837
    0.028132672
    0.029912098
    0.040832157
    0.125067823
    0.288169502
    ];
    elseif nuts_soil=="G_L"
        initfreq=[0
    0.025037812
    0.068338479
    0.082640147
    0.104089393
    0.106405199
    0.090853927
    0.038174909
    0.044451285
    0.042403383
    0.11920978
    0.278395687
    ];
     elseif nuts_soil=="H_H"
        initfreq=[0.028685382
    0.080986584
    0.039641048
    0.066145958
    0.014174438
    0.082433807
    0.068815425
    0.014811409
    0.065994827
    0.072953079
    0.087149336
    0.378208708
    ];
    elseif nuts_soil=="H_M"
        initfreq=[0.073575861
    0.052726464
    0.035623125
    0.041996207
    0.027037553
    0.090138748
    0.08648547
    0.034047752
    0.049261411
    0.055817781
    0.099737168
    0.353552459
    ];
    elseif nuts_soil=="H_L"
        initfreq=[0.093190965
    0.037494972
    0.047932052
    0.045594674
    0.029299314
    0.082030422
    0.112543848
    0.043481806
    0.057321352
    0.057713823
    0.119332922
    0.274063848
    ];
    elseif nuts_soil=="I_H"
        initfreq=[0
    0.0611924
    0.112159397
    0.411690964
    0.004149868
    0.014550394
    0.120307253
    0.00072504
    0.034385576
    0.030836535
    0.050140479
    0.159862094
    ];
    elseif nuts_soil=="I_M"
        initfreq=[0.00142884
    0.078061287
    0.097067676
    0.237884165
    0.00797226
    0.04967786
    0.123226295
    0.015975403
    0.050182824
    0.044970049
    0.069225501
    0.224327842
    ];
    elseif nuts_soil=="I_L"
        initfreq=[0
    0.057157813
    0.080697274
    0.208114023
    0.004204575
    0.08115949
    0.145057841
    0.014253525
    0.033000237
    0.072566702
    0.044827883
    0.258960635
    ];
    elseif nuts_soil=="J_H"
        initfreq=[6.86E-05
    0.054122228
    0.084982348
    0.18510261
    0.052767799
    0.091288153
    0.070137277
    0.003753491
    0.050939571
    0.059840727
    0.089647119
    0.257350055
    ];
    elseif nuts_soil=="J_M"
        initfreq=[0.000373665
    0.046598108
    0.079498183
    0.127850603
    0.048384046
    0.111409978
    0.070776547
    0.008454838
    0.087853644
    0.057496417
    0.091999919
    0.269304051
    ];
    elseif nuts_soil=="J_L"
        initfreq=[0.000222797
    0.041819212
    0.090433178
    0.155498781
    0.054142694
    0.107493265
    0.089688615
    0.008945133
    0.054151815
    0.045704325
    0.074822374
    0.277077811
    ];
    elseif nuts_soil=="K_H"
        initfreq=[0
    0.02875372
    0.092649673
    0.155347235
    0.132672058
    0.087621782
    0.085971893
    0.003655769
    0.046724964
    0.048721545
    0.105352766
    0.212528595
    ];
    elseif nuts_soil=="K_M"
        initfreq=[0
    0.015497331
    0.098388484
    0.170088879
    0.109805321
    0.066492847
    0.095604065
    0.014938554
    0.091220314
    0.051577575
    0.101889168
    0.184497462
    ];
    elseif nuts_soil=="K_L"
        initfreq=[0
    0.011860857
    0.103969411
    0.176048041
    0.147193692
    0.032645896
    0.148362199
    0.036713095
    0.073318854
    0.038124614
    0.089925491
    0.141837849
    ];
    elseif nuts_soil=="L_H"
        initfreq=[0
    0
    0.076754244
    0.367323884
    0.054270993
    0.084215848
    0.140048769
    0.008332985
    0.039358732
    0.03265035
    0.085823696
    0.111220498
    ];
    elseif nuts_soil=="L_M"
        initfreq=[0
    0.004407394
    0.096261655
    0.492721242
    0.083954651
    0.021200605
    0.065559349
    0.014300862
    0.055759776
    0.028728745
    0.055038965
    0.082066755
    ];
    elseif nuts_soil=="L_L"
        initfreq=[0
    0.005030985
    0.075614732
    0.447409911
    0.141130545
    0.024558086
    0.067834773
    0.011201808
    0.026879062
    0.026272661
    0.063962237
    0.1101052
    ];
    elseif nuts_soil=="M_H"
        initfreq=[0
    0
    0.054772486
    0.847211849
    0.001192821
    0
    0.01811547
    6.79E-17
    0.056156817
    0.021468433
    0.00071224
    0.000369884
    ];
    elseif nuts_soil=="M_M"
        initfreq=[0
    0.006052642
    0.101992461
    0.218344172
    0.023870538
    0.038739031
    0.072268057
    0.031158225
    0.23369905
    0.081433627
    0.061988929
    0.130453268
    ];
    elseif nuts_soil=="M_L"
        initfreq=[0
    0.004479833
    0.118132601
    0.161310027
    0.016341992
    0.036241886
    0.071304692
    0.030549123
    0.313895783
    0.132245622
    0.041399894
    0.074098547
    ];

    end
end