function probmat = readtransitionmatrix(nuts_soil,numcrops)
    %read in the transition matrix for the chosen nuts_soil region. Note these are 
    %probability of going from rows to columns
    if nuts_soil=="C_H"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	1
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0	0	0.727272727	0	0	0.136363636	0	0.090909091	0	0	0.045454545
    0	0.022354888	0.224723574	0	0.004025389	0.120688572	0.228772995	0.01584536	0.061902988	0.094612483	0.022613229	0.204460521
    0	0	0	0	0.0625	0	0.0625	0	0.0625	0.0625	0	0.75
    0	0.083333333	0.5	0	0	0.041666667	0.125	0	0	0.083333333	0.041666667	0.125
    0	0.022354888	0.224723574	0	0.004025389	0.120688572	0.228772995	0.01584536	0.061902988	0.094612483	0.022613229	0.204460521
    0	0	0.166666667	0	0	0.833333333	0	0	0	0	0	0
    0	0	0	0	0	0.5	0.2	0	0	0.1	0	0.2
    0	0	0	0	0	1	0	0	0	0	0	0
    0	0	0.047619048	0	0	0.333333333	0.047619048	0.047619048	0.095238095	0	0.095238095	0.333333333
    ];
    elseif nuts_soil=="C_M"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.017452007	0.081151832	0	0.011343805	0.015706806	0.046247818	0.005235602	0.109075044	0.034031414	0.061082024	0.618673647
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.039215686	0	0.423124805	0.020385932	0.028789293	0.086212263	0.006847183	0.100529101	0.029723	0.06660442	0.198568316
    0	0.02	0.368571429	0	0.028571429	0.002857143	0.117142857	0	0.142857143	0.037142857	0.02	0.262857143
    0	0.001021242	0.009395425	0	0.002655229	0.000204248	0.008986928	0.000612745	0.032271242	0.012050654	0.020629085	0.912173203
    0	0.02364532	0.183251232	0	0.014449918	0.106075534	0.130049261	0.003284072	0.088998358	0.02364532	0.129064039	0.297536946
    0	0	0.062295082	0	0.006557377	0	0.032786885	0.003278689	0.062295082	0.009836066	0.009836066	0.813114754
    0	0.024267399	0.172619048	0	0.029761905	0.089285714	0.078754579	0.006868132	0.176282051	0.058608059	0.156135531	0.207417582
    0	0.068202765	0.07235023	0	0.00921659	0.060829493	0.066820276	0.007834101	0.171889401	0.056682028	0.23640553	0.249769585
    0	0.021998743	0.085166562	0	0.009113765	0.490100566	0.04698303	0.005028284	0.045883092	0.018070396	0.154305468	0.123350094
    0	0.034415584	0.035795455	0	0.010227273	0.084577922	0.056168831	0.012418831	0.083685065	0.029545455	0.269074675	0.384090909
    ];
    elseif nuts_soil=="C_L"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0.088888889	0	0.044444444	0.016666667	0.083333333	0	0.05	0.033333333	0.083333333	0.6
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.036432161	0	0.307788945	0.016331658	0.046482412	0.091708543	0.007537688	0.136934673	0.046482412	0.064070352	0.246231156
    0	0.049382716	0.271604938	0	0.160493827	0	0.098765432	0	0.12345679	0.061728395	0.024691358	0.209876543
    0	0	0.019002375	0	0.001187648	0	0.01543943	0.002375297	0.042755344	0.011876485	0.017814727	0.889548694
    0	0.026465028	0.217391304	0	0.013232514	0.100189036	0.11342155	0.003780718	0.083175803	0.047258979	0.132325142	0.262759924
    0	0	0.018867925	0	0	0	0.037735849	0.018867925	0.056603774	0.018867925	0.018867925	0.830188679
    0	0.01826484	0.182648402	0	0.02283105	0.059360731	0.070776256	0.01369863	0.164383562	0.020547945	0.194063927	0.253424658
    0	0.048165138	0.059633028	0	0.009174312	0.077981651	0.075688073	0.013761468	0.133027523	0.055045872	0.29587156	0.231651376
    0	0.017921147	0.077060932	0	0.011648746	0.47311828	0.049283154	0.008960573	0.053763441	0.034050179	0.166666667	0.107526882
    0	0.02952953	0.042542543	0	0.016516517	0.0995996	0.045545546	0.015515516	0.092092092	0.035035035	0.268768769	0.354854855
    ];
    elseif nuts_soil=="D_H"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    0	0	1	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    ];
    elseif nuts_soil=="D_M"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.02173913	0.09057971	0	0.072463768	0.025362319	0.14673913	0.027173913	0.092391304	0.10326087	0.063405797	0.356884058
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.005901538	0	0.711678832	0.056918776	0.003804939	0.051793757	0.011725423	0.066858208	0.027100481	0.021509551	0.042708495
    0	0.005854178	0.163916977	0	0.460883449	0.00266099	0.088877062	0.027674295	0.057477382	0.054284194	0.021287919	0.117083555
    0	0.006265664	0.053884712	0	0.026315789	0.010025063	0.071428571	0.006265664	0.060150376	0.082706767	0.0839599	0.598997494
    0	0.012513802	0.167464115	0	0.097165992	0.032756717	0.298859036	0.041589989	0.105631211	0.091645197	0.052263526	0.100110416
    0	0.001287001	0.063063063	0	0.18018018	0.001287001	0.146718147	0.041184041	0.146718147	0.176319176	0.051480051	0.191763192
    0	0.007892429	0.268634902	0	0.07337036	0.014323297	0.100263081	0.019584917	0.238526747	0.108740134	0.097047647	0.071616486
    0	0.009397024	0.180892717	0	0.072826938	0.015661707	0.142521535	0.019577134	0.22083007	0.126076742	0.125293657	0.086922475
    0	0.014053254	0.182322485	0	0.040680473	0.112426036	0.091715976	0.023298817	0.129807692	0.067307692	0.232618343	0.105769231
    0	0.019869281	0.114509804	0	0.071372549	0.061437908	0.071111111	0.039215686	0.111633987	0.082352941	0.160261438	0.268235294
    ];
    elseif nuts_soil=="D_L"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.014344262	0.081967213	0	0.094262295	0.020491803	0.159836066	0.057377049	0.098360656	0.135245902	0.081967213	0.256147541
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.009949278	0	0.435817401	0.134802965	0.006437768	0.104369879	0.048966055	0.083495903	0.0472103	0.043503707	0.085446742
    0	0.010757946	0.098288509	0	0.527628362	0	0.092909535	0.031784841	0.041564792	0.046943765	0.028850856	0.121271394
    0	0	0.04432133	0	0.024930748	0.005540166	0.051246537	0.026315789	0.049861496	0.074792244	0.088642659	0.63434903
    0	0.010405827	0.122788762	0	0.125563649	0.020117933	0.364203954	0.060700659	0.069372182	0.105445716	0.044398196	0.077003122
    0	0.003236246	0.074433657	0	0.140776699	0.000809061	0.186893204	0.067152104	0.106796117	0.180420712	0.042071197	0.197411003
    0	0.011320755	0.222102426	0	0.074932615	0.028032345	0.127762803	0.044743935	0.208086253	0.107816712	0.097574124	0.077628032
    0	0.007476636	0.154205607	0	0.081308411	0.023364486	0.16728972	0.068224299	0.140186916	0.153271028	0.106542056	0.098130841
    0	0.017370892	0.15258216	0	0.059624413	0.136619718	0.092018779	0.051643192	0.089201878	0.049765258	0.248826291	0.102347418
    0	0.014877102	0.091849935	0	0.081824062	0.061125485	0.090556274	0.056921087	0.067917206	0.069534282	0.196959897	0.26843467
    ];
    elseif nuts_soil=="E_H"
        probmat=[0.02020202	0.015151515	0	0	0.04040404	0	0.126262626	0.055555556	0.136363636	0.227272727	0.005050505	0.373737374
    0.014450867	0.01300578	0.023121387	0	0.027456647	0.044797688	0.078034682	0.011560694	0.079479769	0.117052023	0.072254335	0.518786127
    0	0	0	1	0	0	0	0	0	0	0	0
    0.012224939	0.012224939	0	0.503667482	0.033414833	0.014669927	0.075794621	0.01792991	0.059494703	0.06193969	0.049714751	0.158924205
    0.026476578	0.012219959	0.150712831	0	0.140529532	0.00814664	0.15885947	0.046843177	0.073319756	0.109979633	0.030549898	0.242362525
    0.001358696	0.001358696	0.006793478	0	0.002717391	0.000679348	0.03736413	0.000679348	0.042798913	0.038043478	0.033967391	0.83423913
    0.015494636	0.024731824	0.252085816	0	0.045292014	0.071811681	0.122765197	0.019070322	0.045887962	0.074493445	0.071811681	0.256555423
    0.012578616	0.006289308	0.009433962	0	0.012578616	0	0.081761006	0.003144654	0.075471698	0.081761006	0.028301887	0.688679245
    0.028301887	0.04245283	0.109669811	0	0.038915094	0.14740566	0.141509434	0.029481132	0.087264151	0.080188679	0.139150943	0.155660377
    0.015884477	0.049097473	0.036823105	0	0.020216606	0.104693141	0.139350181	0.039711191	0.095306859	0.102527076	0.151624549	0.244765343
    0.035739313	0.037841626	0.096706377	0	0.023125438	0.334267694	0.138752628	0.028030834	0.05746321	0.056061668	0.117028732	0.074982481
    0.029817088	0.04059133	0.027311451	0	0.018291155	0.128038086	0.128038086	0.046855425	0.081683789	0.08243548	0.157855174	0.259082937
    ];
    elseif nuts_soil=="E_M"
        probmat=[0.01416122	0.007625272	0.011982571	0	0.035947712	0.004357298	0.110021786	0.023965142	0.184095861	0.18627451	0.020697168	0.40087146
    0.008314437	0.020156211	0.023431595	0	0.012093726	0.0239355	0.065255732	0.009322247	0.051398337	0.056185437	0.061980348	0.66792643
    0	0	0	1	0	0	0	0	0	0	0	0
    0.003646398	0.009165271	0	0.635655859	0.034000197	0.012516015	0.054794521	0.010544989	0.044150981	0.040898788	0.039716172	0.114910811
    0.019916628	0.014821677	0.16905975	0	0.120426123	0.004168597	0.132468736	0.021769338	0.089393238	0.066697545	0.036591014	0.324687355
    0.002393719	0.000574493	0.006702413	0	0.003734201	0.001436231	0.021256224	0.001436231	0.024990425	0.020394485	0.032841823	0.884239755
    0.01174743	0.024302496	0.223127753	0	0.043024963	0.067547724	0.1510279	0.016152717	0.065198238	0.06732746	0.065932452	0.264610866
    0.008442777	0.002345216	0.013133208	0	0.014071295	0.002814259	0.039868668	0.003283302	0.072232645	0.053470919	0.03424015	0.756097561
    0.016635514	0.046915888	0.154392523	0	0.028785047	0.152897196	0.104485981	0.031962617	0.108971963	0.102056075	0.12728972	0.125607477
    0.010964366	0.042736108	0.064291054	0	0.025541989	0.086842761	0.106902567	0.038873661	0.120732619	0.099177673	0.181659606	0.222277598
    0.016133545	0.035717616	0.064720694	0	0.022102024	0.430849576	0.085517113	0.032826634	0.053343281	0.048587149	0.136622214	0.073580155
    0.02152697	0.04559067	0.030229363	0	0.017440017	0.114751788	0.08159814	0.042948244	0.080153613	0.065285558	0.194764472	0.305711165
    ];
    elseif nuts_soil=="E_L"
        probmat=[0.034865293	0.009508716	0.023771791	0	0.047543582	0	0.12044374	0.04437401	0.153724247	0.282091918	0.015847861	0.267828843
    0.016381236	0.025316456	0.033507074	0	0.023827252	0.041697692	0.057334326	0.017870439	0.058823529	0.069992554	0.078927774	0.576321668
    0	0	0	1	0	0	0	0	0	0	0	0
    0.014975982	0.012715456	0	0.520486013	0.043797683	0.020627296	0.075727607	0.021192427	0.057925968	0.047188471	0.047188471	0.138174626
    0.039184953	0.021159875	0.155956113	0	0.189655172	0.000783699	0.132445141	0.030564263	0.063479624	0.073667712	0.037617555	0.255485893
    0.002002861	0.000286123	0.010586552	0	0.002288984	0.00286123	0.022031474	0.004577969	0.021745351	0.020314735	0.026037196	0.887267525
    0.024629798	0.019945603	0.26881233	0	0.061196736	0.063009973	0.144303415	0.028558477	0.05741916	0.063161076	0.066183137	0.202780296
    0.010070493	0.005035247	0.024169184	0	0.028197382	0.001007049	0.053373615	0.01611279	0.0775428	0.080563948	0.044310171	0.659617321
    0.032258065	0.036465638	0.124357176	0	0.040205704	0.135577373	0.096306685	0.038803179	0.106591865	0.110799439	0.15942029	0.119214586
    0.023340627	0.036834427	0.070751276	0	0.034281546	0.083150985	0.094456601	0.033552152	0.090080233	0.094821298	0.210430343	0.228300511
    0.02890933	0.036136662	0.067236093	0	0.031318441	0.356767411	0.08848007	0.043583005	0.055847569	0.043363995	0.174332019	0.074025405
    0.032967033	0.032859298	0.039646628	0	0.022301228	0.116461969	0.079293256	0.042663219	0.064102564	0.056345615	0.239280328	0.274078862
    ];
    elseif nuts_soil=="F_H"
        probmat=[0.036028823	0.008807046	0.008807046	0	0.045636509	0	0.166533227	0.03122498	0.164931946	0.161729384	0.066453163	0.309847878
    0.002846975	0.016370107	0.019928826	0	0.008540925	0.040332147	0.052431791	0.004507711	0.027520759	0.057888493	0.073072361	0.696559905
    0	0	0	1	0	0	0	0	0	0	0	0
    0.008463893	0.025931929	0	0.48352242	0.047001621	0.04376013	0.077795786	0.003601657	0.034215739	0.043940212	0.059247254	0.172519359
    0.019911504	0.01460177	0.102212389	0	0.231415929	0.002212389	0.111946903	0.017256637	0.046902655	0.045132743	0.076548673	0.331858407
    0.002688563	0.00283389	0.00828368	0	0.003633193	0.000508647	0.024415056	0.001307949	0.017584653	0.036404592	0.062563581	0.839776195
    0.020563665	0.037822455	0.190672909	0	0.041861746	0.118608281	0.165335537	0.01725879	0.047186266	0.072982649	0.060589369	0.227118333
    0.054080629	0.000983284	0.014749263	0	0.029498525	0.000983284	0.109144543	0.02359882	0.029498525	0.034414946	0.061946903	0.641101278
    0.033954912	0.054272196	0.066796549	0	0.036459783	0.311995547	0.101864737	0.013080991	0.089340384	0.091845255	0.086278876	0.114110771
    0.017045455	0.077797203	0.052229021	0	0.026879371	0.233391608	0.096809441	0.008522727	0.105332168	0.120847902	0.081512238	0.179632867
    0.022786359	0.045113932	0.107814651	0	0.030585716	0.417800887	0.075852577	0.009787429	0.04205536	0.060253861	0.092521792	0.095427435
    0.030796185	0.079657388	0.035507105	0	0.033093245	0.290286159	0.082499513	0.01748102	0.070897411	0.086743235	0.114969827	0.158068912
    ];
    elseif nuts_soil=="F_M"
        probmat=[0.043978627	0.018084669	0.006987259	0	0.030415125	0.000411015	0.15865187	0.038224414	0.169338266	0.155363748	0.04891081	0.329634196
    0.00842249	0.015706806	0.035283405	0	0.010471204	0.043250626	0.064875939	0.00842249	0.033917596	0.04529934	0.08126565	0.653084453
    0	0	0	1	0	0	0	0	0	0	0	0
    0.009086636	0.032586558	0	0.406078646	0.086166379	0.052483158	0.093843021	0.007206643	0.051543162	0.043709854	0.059533135	0.157762807
    0.019590643	0.01871345	0.12251462	0	0.20994152	0.001461988	0.106432749	0.018128655	0.039181287	0.04619883	0.073099415	0.344736842
    0.00406841	0.004219091	0.007835455	0	0.007609433	0.000904091	0.02546523	0.003088978	0.02380773	0.032321254	0.055224893	0.835455436
    0.033895265	0.037930416	0.143561693	0	0.050304878	0.112446198	0.194494261	0.032639885	0.06025825	0.059182209	0.06106528	0.214221664
    0.046811001	0.007606788	0.0093622	0	0.025160913	0.006436513	0.122878877	0.033352838	0.045640726	0.040959626	0.060854301	0.60093622
    0.037969624	0.048960831	0.069544365	0	0.034972022	0.282174261	0.100519584	0.017585931	0.10871303	0.087529976	0.098321343	0.113709033
    0.030347172	0.073075989	0.054382132	0	0.029376062	0.203932993	0.126487011	0.01942219	0.109735373	0.100267055	0.094925953	0.15804807
    0.034405664	0.043100236	0.089554093	0	0.041858154	0.399205068	0.079369022	0.01291765	0.051297975	0.039125574	0.121351385	0.087815178
    0.053840006	0.078107971	0.03269636	0	0.037855119	0.232216813	0.087989537	0.026447722	0.079415825	0.070951101	0.131366708	0.169112839
    ];
    elseif nuts_soil=="F_L"
        probmat=[0.068427371	0.017406963	0.018607443	0	0.070228091	0.00120048	0.232292917	0.077430972	0.108643457	0.111644658	0.047418968	0.246698679
    0.026058632	0.021172638	0.052117264	0	0.029315961	0.026058632	0.095276873	0.026058632	0.056188925	0.053745928	0.078990228	0.535016287
    0	0	0	1	0	0	0	0	0	0	0	0
    0.040720103	0.030432919	0	0.328761252	0.108444063	0.040720103	0.095156451	0.023146164	0.079725675	0.056579511	0.065580797	0.130732962
    0.053112507	0.016561965	0.113649343	0	0.189034837	0.001713307	0.146773272	0.047972587	0.059394632	0.054825814	0.053683609	0.263278127
    0.013601419	0.004139562	0.01655825	0	0.007096393	0.001774098	0.044352454	0.010053223	0.021584861	0.035481963	0.071555293	0.773802484
    0.073529412	0.019924099	0.136622391	0	0.066729918	0.045224541	0.234187223	0.076850095	0.059930424	0.049652119	0.050126502	0.187223276
    0.078530716	0.01139962	0.016466118	0	0.027865738	0.000633312	0.161494617	0.0569981	0.029765674	0.029132362	0.050664978	0.537048765
    0.06810982	0.030095037	0.103484688	0	0.05438226	0.209081309	0.123548046	0.047518479	0.099788807	0.080253432	0.088701162	0.095036959
    0.059167275	0.043827611	0.104455807	0	0.052593134	0.15558802	0.135135135	0.046018992	0.111760409	0.086194302	0.083272462	0.121986852
    0.074735691	0.037550128	0.08640175	0	0.049945315	0.328472475	0.090047393	0.041560335	0.072548305	0.049216187	0.100255195	0.069267226
    0.102877698	0.061990408	0.042206235	0	0.046882494	0.176258993	0.128297362	0.063669065	0.072901679	0.055995204	0.113788969	0.135131894
    ];
    elseif nuts_soil=="G_H"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.007709251	0.019823789	0	0.017621145	0.024229075	0.035242291	0	0.007709251	0.049559471	0.1530837	0.685022026
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.034503632	0	0.155569007	0.078087167	0.06779661	0.157384988	0.010290557	0.036319613	0.06598063	0.096246973	0.297820823
    0	0.004444444	0.097777778	0	0.24	0	0.106666667	0.017777778	0.026666667	0.035555556	0.128888889	0.342222222
    0	0.001999	0.015992004	0	0.0009995	0.00149925	0.023988006	0.00149925	0.013493253	0.036981509	0.104947526	0.7986007
    0	0.041322314	0.123966942	0	0.073744437	0.068022886	0.232040687	0.007628735	0.036236491	0.06675143	0.096630642	0.253655435
    0	0.008130081	0.06504065	0	0.073170732	0.024390244	0.113821138	0.016260163	0.048780488	0.016260163	0.178861789	0.455284553
    0	0.084482759	0.148275862	0	0.043103448	0.246551724	0.081034483	0.003448276	0.037931034	0.101724138	0.106896552	0.146551724
    0	0.059382423	0.128266033	0	0.042755344	0.117577197	0.090261283	0.002375297	0.052256532	0.138954869	0.090261283	0.277909739
    0	0.068745571	0.129695252	0	0.035435861	0.362863218	0.098511694	0.008504607	0.029057406	0.041105599	0.086463501	0.139617293
    0	0.10085796	0.069399428	0	0.046901811	0.208770257	0.078551001	0.008388942	0.054528122	0.101048618	0.146234509	0.185319352
    ];
    elseif nuts_soil=="G_M"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.009966777	0.055647841	0	0.022009967	0.025332226	0.062292359	0.004152824	0.020348837	0.029900332	0.149086379	0.621262458
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.017135657	0	0.424275514	0.106929861	0.026795464	0.088786224	0.024611508	0.038723226	0.038807224	0.059554809	0.174380512
    0	0.005022931	0.107447041	0	0.266652107	0.000873553	0.096746014	0.01921817	0.026206595	0.032976632	0.101987333	0.342869622
    0	0.002008744	0.015242822	0	0.006262555	0.005317263	0.033676001	0.007680492	0.008034976	0.011107172	0.125605577	0.785064398
    0	0.019845933	0.137354746	0	0.090873482	0.097924011	0.225878052	0.034338687	0.035774905	0.053531793	0.104321713	0.200156678
    0	0.003063457	0.031509847	0	0.028446389	0.003501094	0.065645514	0.006564551	0.018818381	0.030634573	0.192997812	0.618818381
    0	0.022700815	0.189173458	0	0.066065192	0.144644936	0.126600698	0.026484284	0.059662398	0.073923166	0.143189756	0.147555297
    0	0.029750837	0.111565638	0	0.057270361	0.111193752	0.102268501	0.020081815	0.049088881	0.087021197	0.147638527	0.284120491
    0	0.030628694	0.12278345	0	0.068645889	0.319586244	0.096856529	0.036405159	0.037614186	0.045943041	0.136620097	0.104916711
    0	0.045186147	0.057163198	0	0.064324302	0.198961431	0.086184514	0.046609992	0.034172285	0.051090917	0.173499728	0.242807488
    ];
    elseif nuts_soil=="G_L"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.009717314	0.054770318	0	0.028268551	0.022084806	0.062720848	0.012367491	0.029151943	0.036219081	0.108657244	0.636042403
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.034747292	0	0.173059567	0.182536101	0.033393502	0.126353791	0.045577617	0.072879061	0.050315884	0.076037906	0.205099278
    0	0.004591368	0.104071013	0	0.317722681	0.000918274	0.107744108	0.02265075	0.032445669	0.037649219	0.090296908	0.281910009
    0	0.002345353	0.024626209	0	0.013485781	0.015244796	0.022574025	0.013485781	0.015831135	0.009967751	0.09762533	0.784813838
    0	0.016979988	0.123104912	0	0.114918132	0.079442086	0.2198302	0.035172832	0.062462098	0.062158884	0.082777441	0.203153426
    0	0.003779289	0.036281179	0	0.055177627	0.003779289	0.0718065	0.0143613	0.03250189	0.037037037	0.111866969	0.633408919
    0	0.03104107	0.14565425	0	0.077841452	0.126074499	0.127029608	0.053963706	0.090735435	0.092645654	0.129417383	0.125596944
    0	0.037484885	0.102781137	0	0.07376058	0.108827086	0.125755744	0.043530834	0.065296252	0.103990326	0.134220073	0.204353083
    0	0.033688939	0.115103874	0	0.092083099	0.287198203	0.08983717	0.049971926	0.051656373	0.046603032	0.147108366	0.086749017
    0	0.044983438	0.058873811	0	0.085051822	0.178010471	0.074794316	0.058766962	0.045838231	0.040282081	0.178331018	0.235067849
    ];
    elseif nuts_soil=="H_H"
        probmat=[0.009783728	0.009783728	0.008753862	0	0.046858908	0.002574665	0.090113285	0.021627188	0.114830072	0.152420185	0.032955716	0.510298661
    0.002602134	0.009237575	0.017954723	0	0.004944054	0.004813947	0.030835285	0.0019516	0.024590164	0.033437419	0.066224304	0.803408795
    0	0	0	1	0	0	0	0	0	0	0	0
    0.014771395	0.044079719	0	0.4007034	0.027432591	0.019695193	0.124032825	0.009847597	0.044314185	0.063071512	0.056506448	0.195545135
    0.078821656	0.019904459	0.172770701	0	0.136146497	0	0.137738854	0.016719745	0.045382166	0.046974522	0.040605096	0.304936306
    0.000714184	0.001285531	0.009141551	0	0.00042851	0.000714184	0.017997429	0.001428367	0.009570061	0.025567776	0.046279103	0.886873304
    0.023375075	0.049970185	0.180083482	0	0.023971377	0.038521169	0.166845558	0.013118664	0.05307096	0.079308289	0.063923673	0.307811568
    0.035618878	0.007123776	0.023152271	0	0.014247551	0.00445236	0.053428317	0.008014248	0.020480855	0.041852182	0.060552093	0.731077471
    0.028444272	0.144930341	0.045085139	0	0.011029412	0.139705882	0.066176471	0.014318885	0.134287926	0.105456656	0.093653251	0.216911765
    0.027554304	0.116049879	0.051086082	0	0.011061947	0.087288817	0.082662912	0.018905873	0.09312148	0.126709574	0.08769107	0.297868061
    0.042112299	0.132687166	0.058322193	0	0.013368984	0.264037433	0.071524064	0.01888369	0.05815508	0.068683155	0.133355615	0.138870321
    0.043222865	0.115056403	0.027003332	0	0.010813022	0.103892688	0.061312759	0.021246128	0.083727863	0.081068444	0.114267345	0.338389152
    ];
    elseif nuts_soil=="H_M"
        probmat=[0.007265522	0.007265522	0.005614267	0	0.049042272	0.000990753	0.070178336	0.022291942	0.107331572	0.172886394	0.036327609	0.520805812
    0.011745198	0.010501589	0.025977615	0	0.008843443	0.008705265	0.044631753	0.008981622	0.016305099	0.028326655	0.068260329	0.767721432
    0	0	0	1	0	0	0	0	0	0	0	0
    0.059174421	0.047005488	0	0.151753758	0.081842042	0.029587211	0.188021952	0.03173467	0.064185159	0.070388929	0.07372942	0.202576951
    0.069257951	0.008480565	0.121201413	0	0.172438163	0	0.134982332	0.038515901	0.036042403	0.050883392	0.059363958	0.308833922
    0.004271632	0.001642935	0.008652793	0	0.002957284	0.000328587	0.023220153	0.003285871	0.005476451	0.012705367	0.055421687	0.88203724
    0.051689217	0.035080612	0.133841044	0	0.032082962	0.043182371	0.189419104	0.033055173	0.04253423	0.059061816	0.078506036	0.301547436
    0.043936202	0.003912128	0.013241047	0	0.026482094	0.000300933	0.069214565	0.012037316	0.025278363	0.035811014	0.055371652	0.714414686
    0.068024596	0.094542659	0.042467333	0	0.018063028	0.149692544	0.089930822	0.032090699	0.099730976	0.076671791	0.130284397	0.198501153
    0.070598182	0.082223631	0.050729233	0	0.020925808	0.091523991	0.093003593	0.036567322	0.06214331	0.091735363	0.151130839	0.249418728
    0.119140843	0.076071149	0.044971473	0	0.020472089	0.319386956	0.090837901	0.035798188	0.032218369	0.035126972	0.122496924	0.103479136
    0.120317699	0.082832457	0.023612751	0	0.019292691	0.113851025	0.078941719	0.053182355	0.05715359	0.049211119	0.135826983	0.265777611
    ];
    elseif nuts_soil=="H_L"
        probmat=[0.007968986	0.009261253	0.016799483	0	0.032737454	0.001723024	0.123411587	0.034460478	0.172517769	0.205470601	0.067844066	0.327805298
    0.0209375	0.0103125	0.043125	0	0.01	0.008125	0.0853125	0.0125	0.0296875	0.0221875	0.0840625	0.67375
    0	0	0	1	0	0	0	0	0	0	0	0
    0.153792865	0.047454105	0	-0.051264288	0.093869068	0.027017665	0.231382057	0.0633876	0.089366124	0.080013855	0.112573606	0.152407343
    0.061308604	0.00927357	0.119010819	0	0.129829985	0.000515198	0.164348274	0.052550232	0.068521381	0.058732612	0.071097372	0.264811953
    0.013921611	0.004069394	0.02334547	0	0.001070893	0.000856714	0.034696937	0.009852217	0.006425359	0.009209681	0.098307989	0.798243735
    0.073015873	0.023696145	0.122222222	0	0.040929705	0.037188209	0.21814059	0.042176871	0.045351474	0.057142857	0.105555556	0.234580499
    0.039964077	0.008980692	0.03143242	0	0.035922766	0.002694207	0.11091154	0.018410418	0.060170633	0.060170633	0.093848226	0.537494387
    0.102977667	0.060297767	0.074193548	0	0.019354839	0.1382134	0.082878412	0.051116625	0.094540943	0.071712159	0.164764268	0.139950372
    0.095280499	0.054318789	0.069011576	0	0.020035619	0.099732858	0.117542297	0.051647373	0.056099733	0.077916296	0.160730187	0.197684773
    0.162989644	0.053579469	0.055230377	0	0.019810896	0.258742308	0.113462404	0.056731202	0.036470059	0.03301816	0.138376107	0.071589374
    0.149256449	0.063611533	0.034294385	0	0.025189681	0.114537178	0.091896813	0.059605463	0.046676783	0.036540212	0.158300455	0.220091047
    ];
    elseif nuts_soil=="I_H"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.037037037	0.018518519	0	0	0	0.018518519	0	0	0.018518519	0.111111111	0.796296296
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.016025641	0	0.727564103	0.006410256	0	0.166666667	0	0.019230769	0.025641026	0.016025641	0.022435897
    0	0	0.1875	0	0.1875	0	0.4375	0	0.0625	0.0625	0	0.0625
    0	0	0.178571429	0	0	0	0.142857143	0	0	0	0.035714286	0.642857143
    0	0.024096386	0.506024096	0	0.006024096	0.006024096	0.180722892	0.006024096	0.030120482	0.024096386	0.036144578	0.180722892
    0	0.083098998	0.366768968	0	0.011007064	0.023822413	0.127534515	0.000410582	0.031236724	0.039422023	0.079987958	0.236710756
    0	0.547619048	0.095238095	0	0	0.023809524	0.047619048	0	0.023809524	0.071428571	0.047619048	0.142857143
    0	0	0.357142857	0	0	0	0.178571429	0	0.107142857	0	0.142857143	0.214285714
    0	0.142857143	0.311688312	0	0	0.168831169	0.051948052	0	0.051948052	0.103896104	0.077922078	0.090909091
    0	0.146226415	0.103773585	0	0	0.028301887	0.094339623	0	0.099056604	0.051886792	0.136792453	0.339622642
    ];
    elseif nuts_soil=="I_M"
        probmat=[0	0	0	0	0	0	0	1	0	0	0	0
    0	0.066666667	0.088888889	0	0	0	0.111111111	0	0	0.044444444	0.066666667	0.622222222
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.034482759	0	0.591954023	0.017241379	0	0.16091954	0	0.017241379	0.028735632	0.057471264	0.091954023
    0	0	0.266666667	0	0.066666667	0	0.466666667	0	0	0.133333333	0	0.066666667
    0	0	0	0	0	0	0.105263158	0	0	0.052631579	0.105263158	0.736842105
    0	0.046511628	0.387596899	0	0.015503876	0.023255814	0.217054264	0.007751938	0.031007752	0.015503876	0.03875969	0.217054264
    0	0.2	0	0	0	0	0	0	0.2	0	0	0.6
    0	0.275	0.075	0	0	0.2	0.175	0.1	0.05	0	0.075	0.05
    0	0.233333333	0.1	0	0	0.033333333	0.066666667	0	0.033333333	0.133333333	0.2	0.2
    0	0	0.214285714	0	0	0.261904762	0.023809524	0	0.238095238	0.023809524	0.047619048	0.19047619
    0.006369427	0.140127389	0.076433121	0	0.006369427	0.076433121	0.121019108	0.038216561	0.082802548	0.095541401	0.108280255	0.248407643
    ];
    elseif nuts_soil=="I_L"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0.090909091	0	0	0	0.090909091	0	0.090909091	0.272727273	0.090909091	0.363636364
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.020408163	0	0.612244898	0	0	0.142857143	0.020408163	0	0.040816327	0.020408163	0.142857143
    0	0	0.5	0	0	0	0.5	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0.5	0	0.5
    0	0.014492754	0.231884058	0	0.028985507	0.014492754	0.275362319	0.043478261	0.043478261	0.028985507	0.072463768	0.246376812
    0	0	0	0	0	0	0.666666667	0	0	0	0	0.333333333
    0	0.090909091	0.181818182	0	0	0.363636364	0.090909091	0	0.090909091	0	0.181818182	0
    0	0.2	0.2	0	0	0.2	0.2	0	0	0	0	0.2
    0	0	0.181818182	0	0	0.181818182	0.090909091	0	0	0	0.090909091	0.454545455
    0	0.128571429	0.042857143	0	0	0.171428571	0.142857143	0.014285714	0.071428571	0.014285714	0.057142857	0.357142857
    ];
    elseif nuts_soil=="J_H"
        probmat=[3.57E-05	0.059428441	0.18346487	0	0.041443038	0.108147767	0.100344126	0.00352281	0.050697623	0.056155596	0.096495916	0.300264086
    0	0.013719512	0.056097561	0	0.0125	0.012804878	0.045426829	0.000304878	0.034146341	0.050914634	0.116768293	0.657317073
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.037465211	0	0.540890602	0.052665382	0.023335474	0.08231642	0.002247913	0.036715907	0.034896168	0.050203383	0.139263541
    0	0.009117281	0.146290924	0	0.288852051	0.001657688	0.084127642	0.014919188	0.029423954	0.028180688	0.084542064	0.312888521
    0	0.002698448	0.018439397	0	0.003597931	0.002473578	0.018889139	0.000449741	0.013267371	0.023386553	0.108837418	0.807960423
    0.000703532	0.044603912	0.310398199	0	0.055297594	0.050232165	0.143942592	0.003376952	0.04235261	0.046855213	0.076825665	0.225411566
    0	0.018987342	0.113924051	0	0.056962025	0.006329114	0.132911392	0.018987342	0.012658228	0.037974684	0.094936709	0.506329114
    0	0.086938607	0.124433457	0	0.048207664	0.215492377	0.079934075	0.004944376	0.126493614	0.1223733	0.070045323	0.121137206
    0	0.108589951	0.11547812	0	0.036466775	0.12560778	0.086709887	0.005267423	0.078606159	0.111831442	0.0863047	0.245137763
    0.000215008	0.059772092	0.183186412	0	0.052461836	0.262094173	0.070092453	0.004515158	0.052246829	0.066222318	0.110728876	0.138464846
    0	0.10191759	0.080286643	0	0.051821379	0.157056599	0.078229713	0.004711034	0.080352996	0.096012209	0.136885409	0.212726428
    ];
    elseif nuts_soil=="J_M"
        probmat=[0	0	0.058823529	0	0.235294118	0	0.176470588	0.058823529	0.058823529	0	0.058823529	0.352941176
    0	0.013956439	0.055614295	0	0.015013745	0.014590823	0.045675619	0.002114612	0.032776486	0.030238951	0.121167266	0.668851766
    0	0	0	1	0	0	0	0	0	0	0	0
    0.000287164	0.039724323	0	0.378194697	0.067483488	0.040490093	0.103953288	0.004786063	0.072748157	0.054752561	0.060495836	0.17708433
    0.000523149	0.009155114	0.170808266	0	0.235155637	0.003400471	0.08998169	0.021972273	0.043159822	0.026419043	0.081349725	0.31807481
    0	0.002337359	0.016361511	0	0.005713544	0.00077912	0.021295936	0.00038956	0.011816647	0.011427087	0.123620309	0.806258927
    0.000555247	0.034758468	0.270627429	0	0.062076624	0.058856191	0.172792893	0.011882288	0.056191005	0.044419767	0.065186008	0.222654081
    0.001550388	0.004651163	0.041860465	0	0.065116279	0.003100775	0.097674419	0.023255814	0.041860465	0.017054264	0.088372093	0.615503876
    0.000706814	0.059230987	0.090613514	0	0.03307888	0.276505513	0.069833192	0.00466497	0.187588352	0.094147583	0.092592593	0.091037602
    0	0.06433121	0.12611465	0	0.028980892	0.122611465	0.088216561	0.005414013	0.103503185	0.104458599	0.108598726	0.247770701
    0.00016518	0.064089858	0.122728774	0	0.045424513	0.369507763	0.065411298	0.007928642	0.064255038	0.056326396	0.093161546	0.111000991
    0.00067559	0.084913229	0.077186167	0	0.049233627	0.132837901	0.067896804	0.01532745	0.151965545	0.088333404	0.12097285	0.210657434
    ];
    elseif nuts_soil=="J_L"
        probmat=[0	1	0	0	0	0	0	0	0	0	0	0
    0	0.01010101	0.069264069	0	0.01010101	0.005772006	0.044733045	0	0.01010101	0.024531025	0.092352092	0.733044733
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.030910132	0	0.418431597	0.07441328	0.044075558	0.119633658	0.003434459	0.070406411	0.040641099	0.042358329	0.155695478
    0	0.01183432	0.147928994	0	0.164201183	0.00591716	0.125739645	0.019230769	0.017751479	0.036982249	0.078402367	0.392011834
    0	0	0.018372703	0	0.001749781	0.006124234	0.026246719	0.000874891	0.015748031	0.015748031	0.079615048	0.83552056
    0.00065703	0.03022339	0.256241787	0	0.061103811	0.063074901	0.230617608	0.017739816	0.042049934	0.044021025	0.054533509	0.199737188
    0	0	0.068627451	0	0.098039216	0.019607843	0.107843137	0.049019608	0.009803922	0.058823529	0.078431373	0.509803922
    0.001658375	0.046434494	0.135986733	0	0.03814262	0.32172471	0.066334992	0.009950249	0.135986733	0.111111111	0.069651741	0.063018242
    0	0.057377049	0.18852459	0	0.043715847	0.133879781	0.06557377	0.00273224	0.090163934	0.076502732	0.114754098	0.226775956
    0	0.034065934	0.167032967	0	0.087912088	0.296703297	0.092307692	0.018681319	0.056043956	0.071428571	0.08021978	0.095604396
    0.000267308	0.091419407	0.091954023	0	0.058005881	0.172681101	0.088211708	0.011494253	0.074311681	0.055332799	0.11173483	0.244587009
    ];
    elseif nuts_soil=="K_H"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.007858546	0.067779961	0	0.023575639	0.010805501	0.064833006	0	0.023575639	0.031434185	0.147347741	0.622789784
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.020550015	0	0.403596253	0.188727712	0.018736778	0.086279843	0.003324267	0.042762164	0.03566032	0.0643699	0.135992747
    0	0.003707365	0.130499259	0	0.390756303	0.001235788	0.093178448	0.005684627	0.026445872	0.035343549	0.068956995	0.244191794
    0	0.003642987	0.009471767	0	0.013843352	0.004371585	0.018214936	0.001821494	0.01129326	0.02003643	0.133333333	0.783970856
    0	0.022609819	0.220930233	0	0.09496124	0.072028424	0.200258398	0.005490956	0.053617571	0.060400517	0.09754522	0.172157623
    0	0	0.141414141	0	0.181818182	0	0.111111111	0	0.01010101	0.03030303	0.141414141	0.383838384
    0	0.049748744	0.180904523	0	0.068844221	0.183417085	0.099497487	0.001507538	0.094472362	0.089447236	0.147738693	0.084422111
    0	0.044372294	0.178571429	0	0.063852814	0.115800866	0.08982684	0.002164502	0.057359307	0.091991342	0.140692641	0.215367965
    0	0.045079147	0.146937371	0	0.074328975	0.35615967	0.088437715	0.005849966	0.043014453	0.052993806	0.100481762	0.086717137
    0	0.062791007	0.096048956	0	0.125315951	0.121990156	0.097778369	0.004523081	0.087135825	0.076626314	0.174271651	0.153518691
    ];
    elseif nuts_soil=="K_M"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.005239823	0.108424023	0	0.021765417	0.006449012	0.069729948	0.004030633	0.043127771	0.041112455	0.115276098	0.584844821
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.01287139	0	0.421546637	0.144069844	0.015632009	0.081058698	0.017081335	0.090686359	0.039994479	0.059560371	0.117498878
    0	0.002790774	0.109661003	0	0.325289338	0.001313305	0.098990396	0.01190183	0.051547238	0.035787573	0.082902405	0.279816137
    0	0.002686916	0.030957944	0	0.013434579	0.008528037	0.044509346	0.002336449	0.023247664	0.016121495	0.113084112	0.745093458
    0	0.012486065	0.220661464	0	0.098253437	0.042512077	0.232998885	0.023039762	0.088294314	0.071869194	0.0827945	0.127090301
    0	0.003103181	0.106283941	0	0.079906905	0.002327386	0.087664856	0.022498061	0.075252133	0.063615206	0.169899147	0.389449185
    0	0.023746301	0.182838935	0	0.060541689	0.152795691	0.119566042	0.019270162	0.160306502	0.091343601	0.108110159	0.08148092
    0	0.024550898	0.158982036	0	0.073652695	0.099101796	0.117365269	0.013473054	0.131137725	0.095808383	0.111377246	0.174550898
    0	0.019647641	0.167898027	0	0.085166843	0.226678574	0.113501664	0.019891207	0.102460015	0.042624016	0.132662174	0.089469838
    0	0.032885906	0.097231544	0	0.107130872	0.090939597	0.080201342	0.018917785	0.143791946	0.074244966	0.183053691	0.171602349
    ];
    elseif nuts_soil=="K_L"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.013071895	0.098039216	0	0.026143791	0.003267974	0.107843137	0.016339869	0.049019608	0.04248366	0.098039216	0.545751634
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.01124903	0	0.409425912	0.164662529	0.008339798	0.124903026	0.031225756	0.08553142	0.026764934	0.048875097	0.089022498
    0	0.002300613	0.086656442	0	0.316334356	0.001917178	0.114647239	0.027607362	0.044861963	0.026840491	0.088957055	0.289877301
    0	0.006265664	0.070175439	0	0.027568922	0.018796992	0.140350877	0.020050125	0.013784461	0.006265664	0.093984962	0.602756892
    0	0.006095496	0.198780901	0	0.105316627	0.017270572	0.314595327	0.076193701	0.072807315	0.059600406	0.070436844	0.078902811
    0	0	0.088516746	0	0.093301435	0	0.148325359	0.033492823	0.055023923	0.074162679	0.122009569	0.385167464
    0	0.030021834	0.211790393	0	0.07150655	0.049672489	0.184497817	0.034388646	0.184497817	0.083515284	0.094978166	0.055131004
    0	0.00802139	0.240641711	0	0.072192513	0.034759358	0.176470588	0.026737968	0.104278075	0.050802139	0.114973262	0.171122995
    0	0.018075802	0.201166181	0	0.132944606	0.113119534	0.181341108	0.047230321	0.085714286	0.033236152	0.137609329	0.049562682
    0	0.029226785	0.086200518	0	0.221605623	0.088420274	0.105438402	0.042175361	0.088790233	0.043285239	0.178690344	0.116167222
    ];
    elseif nuts_soil=="L_H"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0.111111111	0	0.148148148	0	0.074074074	0	0.148148148	0.037037037	0.111111111	0.37037037
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0	0	0.791044776	0.055970149	0.01119403	0.070895522	0.007462687	0.014925373	0.01119403	0.01119403	0.026119403
    0	0	0.3	0	0.25	0	0.25	0	0	0.05	0.05	0.1
    0	0	0.06122449	0	0	0	0.040816327	0.020408163	0.040816327	0.06122449	0.102040816	0.673469388
    0	0	0.189655172	0	0.051724138	0.120689655	0.465517241	0	0.034482759	0.034482759	0.068965517	0.034482759
    0	0	0	0	0	0	0.083333333	0.083333333	0.333333333	0.083333333	0.25	0.166666667
    0	0	0.108108108	0	0.054054054	0.081081081	0.162162162	0	0.162162162	0.108108108	0.297297297	0.027027027
    0	0	0.333333333	0	0	0.166666667	0.166666667	0	0.166666667	0	0.166666667	0
    0	0	0.111111111	0	0.018518519	0.314814815	0.12962963	0.037037037	0.092592593	0.055555556	0.222222222	0.018518519
    0	0	0.036697248	0	0.082568807	0.247706422	0.073394495	0	0.027522936	0.055045872	0.201834862	0.275229358
    ];
    elseif nuts_soil=="L_M"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.002336449	0.275700935	0	0.056074766	0.021028037	0.123831776	0.014018692	0.086448598	0.044392523	0.091121495	0.285046729
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.004419541	0	0.804632626	0.049798753	0.003275195	0.032396812	0.008918002	0.039183963	0.015902454	0.012706179	0.028766475
    0	0.001979414	0.140142518	0	0.426761679	0.001979414	0.083135392	0.017418844	0.043942993	0.035629454	0.063341251	0.185669042
    0	0.001821494	0.059198543	0	0.017304189	0.012750455	0.058287796	0.013661202	0.040983607	0.011839709	0.152094718	0.632058288
    0	0.002959553	0.390003288	0	0.082538639	0.021703387	0.165406116	0.021703387	0.108845774	0.078263729	0.065110161	0.063465965
    0	0.001855288	0.213358071	0	0.059369202	0.005565863	0.115027829	0.035250464	0.107606679	0.025974026	0.146567718	0.289424861
    0	0.005416792	0.346975624	0	0.039723142	0.024375564	0.177851339	0.030093289	0.185073729	0.060186578	0.075534156	0.054769786
    0	0.004008016	0.256513026	0	0.064128257	0.034068136	0.177354709	0.03006012	0.130260521	0.073146293	0.118236473	0.112224449
    0	0.00871731	0.276878373	0	0.075550021	0.108758821	0.131174761	0.01909506	0.080116231	0.0498132	0.175176422	0.074719801
    0	0.010932106	0.139528193	0	0.103567319	0.112485616	0.074510932	0.031357883	0.053222094	0.045742232	0.197640967	0.231012658
    ];
    elseif nuts_soil=="L_L"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0.020408163	0.244897959	0	0.06122449	0	0.244897959	0	0.020408163	0.081632653	0.020408163	0.306122449
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.003660769	0	0.830994509	0.054301403	0.007626602	0.031116534	0.003050641	0.019219036	0.013422819	0.008541794	0.028065894
    0	0.001988072	0.085487078	0	0.530815109	0	0.093439364	0.019880716	0.02584493	0.019880716	0.039761431	0.182902584
    0	0	0.071428571	0	0.010204082	0.020408163	0.071428571	0.010204082	0.051020408	0.030612245	0.173469388	0.56122449
    0	0.00297619	0.24702381	0	0.139880952	0.029761905	0.282738095	0.029761905	0.053571429	0.068452381	0.06547619	0.080357143
    0	0.028571429	0.214285714	0	0.228571429	0	0.128571429	0.042857143	0.071428571	0.014285714	0.085714286	0.185714286
    0	0.041176471	0.347058824	0	0.094117647	0.047058824	0.105882353	0.011764706	0.058823529	0.129411765	0.082352941	0.082352941
    0	0.013157895	0.236842105	0	0.078947368	0.039473684	0.078947368	0.013157895	0.118421053	0.078947368	0.105263158	0.236842105
    0	0.008163265	0.175510204	0	0.065306122	0.142857143	0.126530612	0.024489796	0.040816327	0.036734694	0.240816327	0.13877551
    0	0.004662005	0.132867133	0	0.186480186	0.065268065	0.037296037	0.018648019	0.013986014	0.032634033	0.221445221	0.286713287
    ];
    elseif nuts_soil=="M_H"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0.5	0	0.5	0	0	0	0	0	0	0
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0	0	0.935349716	0.000378072	0	0.01020794	0	0.036672968	0.017391304	0	0
    0	0	0.8	0	0	0	0.2	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0.571428571	0	0.015873016	0	0.26984127	0	0.095238095	0.031746032	0.015873016	0
    0	0	0.4	0	0	0	0	0	0.2	0	0	0.4
    0	0	0.5625	0	0.010416667	0	0.057291667	0	0.270833333	0.09375	0	0.005208333
    0	0	0.527777778	0	0	0	0.041666667	0	0.375	0.041666667	0.013888889	0
    0	0	0.620689655	0	0	0	0.172413793	0	0.068965517	0	0.103448276	0.034482759
    0	0	0.285714286	0	0	0	0.285714286	0	0.142857143	0	0.142857143	0.142857143
    ];
    elseif nuts_soil=="M_M"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0.5	0	0.5	0	0	0	0	0	0	0
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0	0	0.935349716	0.000378072	0	0.01020794	0	0.036672968	0.017391304	0	0
    0	0	0.8	0	0	0	0.2	0	0	0	0	0
    0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0.571428571	0	0.015873016	0	0.26984127	0	0.095238095	0.031746032	0.015873016	0
    0	0	0.4	0	0	0	0	0	0.2	0	0	0.4
    0	0	0.5625	0	0.010416667	0	0.057291667	0	0.270833333	0.09375	0	0.005208333
    0	0	0.527777778	0	0	0	0.041666667	0	0.375	0.041666667	0.013888889	0
    0	0	0.620689655	0	0	0	0.172413793	0	0.068965517	0	0.103448276	0.034482759
    0	0	0.285714286	0	0	0	0.285714286	0	0.142857143	0	0.142857143	0.142857143
    ];
    elseif nuts_soil=="M_L"
        probmat=[0	0	0	0	0	0	0	0	0	0	0	0
    0	0	0.166666667	0	0.015151515	0.034632035	0.062770563	0.034632035	0.248917749	0.114718615	0.04978355	0.272727273
    0	0	0	1	0	0	0	0	0	0	0	0
    0	0.006653144	0	0.267667343	0.025720081	0.018174442	0.096957404	0.032373225	0.357241379	0.14158215	0.019310345	0.034320487
    0	0.004175365	0.331941545	0	0.060542797	0.073068894	0.083507307	0.022964509	0.229645094	0.091858038	0.016701461	0.08559499
    0	0.001739887	0.029578077	0	0.006089604	0.008264463	0.034362766	0.007829491	0.180513267	0.094388865	0.064810787	0.572422793
    0	0.003383191	0.211894587	0	0.029024217	0.045405983	0.165420228	0.032051282	0.264245014	0.140135328	0.029736467	0.078703704
    0	0.001612903	0.073655914	0	0.015053763	0.002688172	0.066129032	0.010752688	0.376344086	0.169892473	0.032795699	0.251075269
    0	0.004355168	0.223535686	0	0.01706515	0.020975913	0.064527598	0.030752822	0.444582704	0.115011999	0.039818683	0.039374278
    0	0.005678269	0.108909204	0	0.013116802	0.015672023	0.080177162	0.046618591	0.38969962	0.246834365	0.042189541	0.051104423
    0	0.004417261	0.09650017	0	0.007475365	0.359836901	0.061501869	0.03024125	0.119266055	0.063880394	0.179408767	0.077471967
    0	0.009230201	0.067011261	0	0.01329149	0.064611409	0.074949234	0.065165221	0.249584641	0.234816319	0.091932804	0.129407421
    ];
    end

    %check each row sums to one - if not adjust
    probmattotal=sum(probmat,2);
    for i=1:numcrops
        for j=1:numcrops
            if probmattotal(i,1)>0
                probmat(i,j)=probmat(i,j)/probmattotal(i,1);
            else
                probmat(i,j)=0;
            end
        end
    end
end